﻿WITH   RECURSIVE nb_disque (nb_disque) AS (VALUES (7)),
       param_mvt (code_mouvement,designation_mouvement) AS (
VALUES ('A','Déplacer un disque de 1 vers 2'),('a','Déplacer un disque de 2 vers 1'),
       ('B','Déplacer un disque de 2 vers 3'),('b','Déplacer un disque de 3 vers 2'), 
       ('C','Déplacer un disque de 3 vers 1'),('c','Déplacer un disque de 1 vers 3')),
       hanoi(nb_disque,num_mvt,cumul_mouvement) AS (
      -- Implémentation de l'algorithme de résolution des Tours de Hanoi en itératif
SELECT nb_disque,0,'A' FROM nb_disque
UNION  ALL
SELECT nb_disque,num_mvt+1,cumul_mouvement||
       CASE MOD((num_mvt+1),4)
       -- On déduit le type de mouvement en fonction du num ordre du mouvement 
       WHEN 0 THEN CASE MOD((num_mvt+1),3) 
                   WHEN 0 THEN 'A' WHEN 1 THEN 'C' ELSE 'B' END
                   WHEN 1 THEN CASE MOD((num_mvt+1),3) 
                               WHEN 0 THEN 'a' WHEN 1 THEN 'c' ELSE 'b' END
                   WHEN 2 THEN CASE MOD((num_mvt+1),3) 
                               WHEN 0 THEN 'A' WHEN 1 THEN 'C' ELSE 'B' END
                   WHEN 3 THEN CASE ASCII(SUBSTR(cumul_mouvement,
                                                 CAST((num_mvt+1-3)/4 AS INTEGER)+1,1)) 
                               BETWEEN 65 AND 67 
                   -- Dépend du mouvement précédent : Code ascii de A, B et C
                                    WHEN TRUE THEN CASE MOD((num_mvt+1),3) 
                                          WHEN 0 THEN 'A' WHEN 1 THEN 'C' ELSE 'B' END 
                                          ELSE CASE MOD((num_mvt+1),3) 
                                          WHEN 0 THEN 'a' WHEN 1 THEN 'c' ELSE 'b' END 
       END END                                                                              
FROM   hanoi WHERE num_mvt+1<2^nb_disque-1)
SELECT num_mvt,param_mvt.code_mouvement,designation_mouvement
FROM   hanoi JOIN   param_mvt 
       ON SUBSTR(cumul_mouvement,num_mvt+1,1)=param_mvt.code_mouvement;
